local placement_spec = {
  Place.new(CellView.new(Vector.new(0, 0)), Basic.new(1)),
  Place.new(CellView.new(Vector.new(1, 0)), Basic.new(1)),
  Place.new(CellView.new(Vector.new(0, 1)), Basic.new(1)),
  Join.new(CellFace.new(Vector.new(0, 0), UP)),
  Join.new(CellFace.new(Vector.new(0, 0), RIGHT))
};
local generate_copy = location.generate_copy;
local generate_target = location.generate_target;

local transformations = {
  CoordinateTransform.new(Vector.new(0, 0)),
  CoordinateTransform.new(Vector.new(0, 1), R1),
  CoordinateTransform.new(Vector.new(1, 1), R2),
  CoordinateTransform.new(Vector.new(1, 0), R3)
};
local function build_source_object(index)
  destroy_rectangle(generate_copy)
  local pattern = transform_interaction_table(placement_spec, transformations[index])
  game:interact(transform_interaction_table(pattern, CoordinateTransform.new(generate_copy.lesser)))
  game:interact(transform_interaction_table(pattern, CoordinateTransform.new(generate_target.lesser)))
end

local generate_index = 0;
local generate_sequence = {3, 4, 3, 4, 1, 2, 1, 4, 1, 2, 3, 4, 1, 2, 1, 2, 1, 4, 3, 2, 1, 2, 3,
2, 3, 2, 1, 2, 3, 4, 1, 4, 3, 2, 3, 4, 3, 2, 3, 2, 3, 2, 3, 4, 3, 2,
1, 4, 1, 4, 1, 4, 1, 2, 1, 2, 1, 2, 3, 2, 3, 2, 3, 2, 3, 4, 3, 2, 1,
2, 1, 4, 1, 2, 3, 4, 3, 2, 1, 2, 3, 4, 3, 4, 1, 4, 1, 2, 1, 2, 3, 4,
3, 2, 3, 4, 3, 4, 3, 2}
local function get_rotation(idx)
  return generate_sequence[(idx % #generate_sequence) + 1]
end
destroy_rectangle(generate_target)
game:each_step(function()
  if rectangle_empty(generate_target) then
    build_source_object(get_rotation(generate_index))
    generate_index = generate_index + 1
  end
end)
